#
# Convert a CSV LEX/CON specification to a TSV specification as accepted by OT-soft.
# usage:
# python3 convert_csv.py input.csv output.tsv
#

import csv
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('csv_filename', metavar='input_file.csv', help='name of input file')
parser.add_argument('tsv_filename', metavar='input_file.tsv', help='name of output file')
args = parser.parse_args()

with open(args.csv_filename, 'r', newline='') as csv_file:
    with open(args.tsv_filename, 'w') as tsv_file:
        reader = csv.reader(csv_file)
        constraint_list = next(reader)[2:]
        print('\t\t\t' + '\t'.join(constraint_list), file=tsv_file)
        print('\t\t\t' + '\t'.join(constraint_list), file=tsv_file)
        ufs = set()
        for row in reader: # underlying form 
            violations = row[2:]
            uf = str(row[0])
            sf = str(row[1])
            if uf in ufs:
                print('\t'.join(['', sf, ''] + violations), file=tsv_file)
            else:
                ufs.add(uf)
                print('\t'.join([uf, sf, ''] + violations), file=tsv_file)
